{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:14:21 $                                        =}
{========================================================================}
unit fmMain;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  ExtCtrls,
  ComCtrls,
  Grids,
  Menus,
  MMObj,
  MMUtils,
  MMSplit,
  MMDesign,
  MMMixer,
  MMAbout,
  MMDevice,
  MMHook, ImgList;

type
  TMainForm = class(TForm)
    TreeView1: TTreeView;
    MMSplitter1: TMMSplitter;
    MMDesigner1: TMMDesigner;
    Device: TMMMixerDevice;
    DestLine: TMMAudioLine;
    SrcLine: TMMAudioLine;
    Control: TMMMixerControl;
    ListView1: TListView;
    ImageList1: TImageList;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Help1: TMenuItem;
    Exit1: TMenuItem;
    About1: TMenuItem;
    View1: TMenuItem;
    Displayall1: TMenuItem;
    CollapseAny1: TMenuItem;
    procedure FormShow(Sender: TObject);
    procedure TreeView1Change(Sender: TObject; Node: TTreeNode);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Displayall1Click(Sender: TObject);
    procedure CollapseAny1Click(Sender: TObject);
  private
    FDataType: TList;
    procedure FillTree;
    procedure ListClear;
    procedure ListAdd(const S1, S2: string);
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

uses
    TypInfo;

type
    TDataType = (dtDevice, dtLine, dtControl, dtItem);

const
    liCustom    = 0;
    liDestLine  = 1;
    liFader     = 2;
    liList      = 3;
    liMeter     = 4;
    liNumber    = 5;
    liSlider    = 6;
    liSrcLine   = 7;
    liSwitch    = 8;
    liTime      = 9;
    liDevice    = 10;

const
    ControlImage : array[TMMControlClass] of Integer = (liCustom,
                                                        liFader,
                                                        liList,
                                                        liMeter,
                                                        liNumber,
                                                        liSlider,
                                                        liSwitch,
                                                        liTime);

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.FormCreate(Sender: TObject);
begin
   FDataType := TList.Create;
   // resize the right column to forms width
   ListView1.Columns[1].Width := ListView1.Width-ListView1.Columns[0].Width-4;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.FormDestroy(Sender: TObject);
begin
   FDataType.Free;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.FormShow(Sender: TObject);
begin
   FillTree;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.FillTree;

  function SetImageIndex(Node: TTreeNode; Index: Integer): TTreeNode;
  begin
     Node.ImageIndex   := Index;
     Node.SelectedIndex:= Index;
     Result            := Node;
  end;

  procedure FillItems(Parent: TTreeNode);
  var
     i : Integer;
  begin
     for i := 0 to Control.Items - 1 do
     begin
        FDataType.Add(Pointer(dtItem));
        SetImageIndex(TreeView1.Items.AddChildObject(Parent,Control.ItemInfo[i].Name,TObject(i)),
                      0); {Should be something new}
     end;
  end;

  procedure FillControls(Parent: TTreeNode; Line: TMMAudioLine);
  var
     i: Integer;
  begin
     Control.AudioLine := Line;
     for i := 0 to Line.Controls - 1 do
     begin
        Control.ControlId := Line.Control[i];
        FDataType.Add(Pointer(dtControl));
        FillItems(SetImageIndex(TreeView1.Items.AddChildObject(Parent,Control.ControlInfo.Name,TObject(Control.ControlId)),
                  ControlImage[Control.ControlClass]));
     end;
  end;

  procedure FillSources(Parent: TTreeNode);
  var
     i: Integer;
  begin
     for i := 0 to DestLine.Connections - 1 do
     begin
        SrcLine.LineId := DestLine.Connection[i];
        FDataType.Add(Pointer(dtLine));
        FillControls(SetImageIndex(TreeView1.Items.AddChildObject(Parent,SrcLine.LineInfo.Name,TObject(SrcLine.LineId)),
                     liSrcLine),SrcLine);
     end;
     FillControls(Parent,DestLine);
  end;

  procedure FillDestinations(Parent: TTreeNode);
  var
     i: Integer;
  begin
     for i := 0 to Device.Destinations - 1 do
     begin
        DestLine.LineId := Device.Destination[i];
        FDataType.Add(Pointer(dtLine));
        FillSources(SetImageIndex(TreeView1.Items.AddChildObject(Parent,DestLine.LineInfo.Name,TObject(DestLine.LineId)),
                    liDestLine));
     end;
  end;

  procedure FillDevices(Parent: TTreeNode);
  var
     i : TMMDeviceId;
  begin
     for i := 0 to Device.DeviceCount - 1 do
     begin
        Device.DeviceId := i;
        FDataType.Add(Pointer(dtDevice));
        FillDestinations(SetImageIndex(TreeView1.Items.AddChildObject(Parent,Device.DeviceCaps.ProductName,TObject(i)),
                         liDevice)); { Should be something new }
     end;
  end;

begin
   FDataType.Clear;
   FillDevices(nil);
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.TreeView1Change(Sender: TObject; Node: TTreeNode);

  function DetectDataType(Node: TTreeNode): TDataType;
  begin
     Result := TDataType(FDataType[Node.AbsoluteIndex]);
  end;

  procedure SetDevice(Node: TTreeNode);
  begin
     if DetectDataType(Node) = dtDevice then
        Device.DeviceId := TMMDeviceId(Node.Data)
     else
        SetDevice(Node.Parent);
  end;

  procedure SetLine(Node: TTreeNode);
  begin
     if DetectDataType(Node) = dtLine then
        DestLine.LineId := TMMLineId(Node.Data)
     else
        SetLine(Node.Parent);
  end;

  procedure SetControl(Node: TTreeNode);
  begin
     Control.AudioLine := DestLine;
     if DetectDataType(Node) = dtControl then
        Control.ControlId := TMMControlId(Node.Data)
     else
        SetControl(Node.Parent);
  end;

  procedure DumpDevice;
  begin
     SetDevice(Node);
     ListClear;
     ListAdd('Type','Device');
     with Device do begin
         ListAdd('Device id', IntToHex(DeviceId,8));
         ListAdd('Destinations',IntToStr(Destinations));
         ListAdd('Manufacturer Id', IntToStr(DeviceCaps.ManufacturerId));
         ListAdd('Product Id', IntToStr(DeviceCaps.ProductId));
         ListAdd('Product name',DeviceCaps.ProductName);
         ListAdd('Version',Format('%d.%d',[DeviceCaps.VerMajor,DeviceCaps.VerMinor]));
         ListAdd('Device count',IntToStr(DeviceCount));
     end;
  end;

  procedure DumpLine;
  var
     FlagStr: string;
  begin
     SetDevice(Node);
     SetLine(Node);
     ListClear;
     ListAdd('Type','Line');
     ListAdd('Line id', IntToHex(DestLine.LineId,8));
     if cfSource in DestLine.LineInfo.Flags then
        ListAdd('Line type', 'Source')
     else
        ListAdd('Line type', 'Destination');
     ListAdd('Name',DestLine.LineInfo.Name);
     ListAdd('Short name',DestLine.LineInfo.ShortName);
     ListAdd('ComponentType',GetEnumName(TypeInfo(TMMComponentType),Ord(DestLine.ComponentType)));
     ListAdd('Channels',IntToStr(DestLine.LineInfo.Channels));
     ListAdd('Connections',IntToStr(DestLine.LineInfo.Connections));
     ListAdd('Controls',IntToStr(DestLine.LineInfo.Controls));
     FlagStr := '';
     if cfActive in DestLine.LineInfo.Flags then
        FlagStr := FlagStr + 'Active ';
     if cfDisconnected in DestLine.LineInfo.Flags then
        FlagStr := FlagStr + 'Disconnected ';
     if cfSource in DestLine.LineInfo.Flags then
        FlagStr := FlagStr + 'Source';
     ListAdd('Flags',FlagStr);
  end;

  procedure DumpControl;
  var
     FlagStr: string;
  begin
     SetDevice(Node);
     SetLine(Node);
     SetControl(Node);
     ListClear;
     ListAdd('Type','Control');
     ListAdd('Control id',IntToHex(Control.ControlId,8));
     ListAdd('Name',Control.ControlInfo.Name);
     ListAdd('Short name',Control.ControlInfo.ShortName);
     ListAdd('Control class',GetEnumName(TypeInfo(TMMControlClass),Ord(Control.ControlClass)));
     FlagStr := '';
     if cfDisabled in Control.ControlInfo.Flags then
        FlagStr := FlagStr + 'Disabled ';
     if cfMultiple in Control.ControlInfo.Flags then
        FlagStr := FlagStr + 'Multiple ';
     if cfUniform in Control.ControlInfo.Flags then
        FlagStr := FlagStr + 'Uniform';
     ListAdd('Flags',FlagStr);
     ListAdd('MinValue',IntToStr(Control.ControlInfo.MinValue));
     ListAdd('MaxValue',IntToStr(Control.ControlInfo.MaxValue));
     ListAdd('MultipleItems',IntToStr(Control.ControlInfo.MultipleItems));
     ListAdd('Steps',IntToStr(Control.ControlInfo.Steps));
     ListAdd('Control type',GetEnumName(TypeInfo(TMMControlType),Ord(Control.ControlType)));
  end;

  procedure DumpItem;
  var
     Item: TMMItemIndex;
  begin
     SetDevice(Node);
     SetLine(Node);
     SetControl(Node);
     Item := TMMItemIndex(Node.Data);
     ListClear;
     ListAdd('Type','Item');
     ListAdd('Name',Control.ItemInfo[Item].Name);
     ListAdd('Val1',IntToHex(Control.ItemInfo[Item].Val1,8));
     ListAdd('Val2',IntToHex(Control.ItemInfo[Item].Val2,8));
  end;

begin
   case DetectDataType(Node) of
      dtDevice : DumpDevice;
      dtLine   : DumpLine;
      dtControl: DumpControl;
      dtItem   : DumpItem;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.ListClear;
begin
   ListView1.Items.Clear;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.ListAdd(const S1, S2: string);
begin
   with ListView1.Items.Add do
   begin
      Caption := S1;
      SubItems.Add(S2);
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.Exit1Click(Sender: TObject);
begin
   Close;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.About1Click(Sender: TObject);
begin
   Show_AboutBox(0);
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.Displayall1Click(Sender: TObject);
begin
   TreeView1.FullExpand;
   TreeView1.Selected  := TreeView1.Items[0];
   TreeView1.TopItem   := TreeView1.Items[0];
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.CollapseAny1Click(Sender: TObject);
begin
   TreeView1.FullCollapse;
end;

end.
